//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *Client::PeekSendData(void)
{
    return SendData;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Client::PeekSizeOfSendData(void)
{
    return SizeOfSendData;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *Client::PeekReceiveData(void)
{
    return ReceiveData;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Client::PeekSizeOfReceiveData(void)
{
    return SizeOfReceiveData;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::IsDataReady(void)
{
    if(SizeOfReceiveData > 0)
        return true;

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::GetReceiveData(char *rBuffer, int *Size)
{
    if(SizeOfReceiveData <= 0)
    {
        *Size = 0;
        return false;
    }

    if(RawMode)
    {
        memcpy(rBuffer, ReceiveData, SizeOfReceiveData);
        *Size = SizeOfReceiveData;
        FreeClientReceive();
        return true;
    }
    else{
        *Size = BreakRecvPacket(rBuffer, ReceiveData, SizeOfReceiveData, &RecvOffset);
        if(*Size == -1)
        {
            Disconnect = true;
            *Size = 0;
            return false;
        }

        if(RecvOffset == -1)
            FreeClientReceive();

    	return true;
    }

	return false; // Should never get here
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::SetSendDataEx(char *String, int Size)
{
    if(SizeOfSendData > 0)
        return false;

    SendData = (char *) calloc(Size + 1, 1);
    memcpy(SendData, String, Size);
    SizeOfSendData = Size;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::SetSendData(char *String)
{
	return SetSendDataEx(String, strlen(String));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::FreeClientSend(void)
{
    if( SendData) free( SendData);
	SendData = NULL;
	SizeOfSendData = 0;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::FreeClientReceive(void)
{
	if(ReceiveData) free(ReceiveData);
	ReceiveData = NULL;
	SizeOfReceiveData = 0;
	RecvOffset = 0;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::FreeClientSendReceive(void)
{
	FreeClientSend();
	FreeClientReceive();
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::DisconnectClient(void)
{
    if(Connected == false)
    {
        Disconnect = false;
        return false;
    }

    DoDisconnect();

	WSASendDisconnect(Socket, NULL);
	shutdown(Socket, SD_BOTH);
	closesocket(Socket);

	FD_CLR(Socket, &ReadFDS);
	FD_CLR(Socket, &WriteFDS);
	FD_CLR(Socket, &ExceptFDS);

	FreeClientSendReceive();

	WSARecvDisconnect(Socket, NULL);

	Disconnect = false;
	Connected  = false;
    RawMode    = false;

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Client::WriteLineToClientEx(char *LineToSend, int Length)
{
    if(RawMode)
    {
        return send(Socket, LineToSend, Length, 0);
    }
    else{
        char SendData[MaxReceiveSize];
        int SendLen = MakeSendPacket(SendData, LineToSend, Length);
        //Encode(&BaseCommCript, SendData, SendData, SendLen);
        return send(Socket, SendData, SendLen, 0);
    }
    return -1; // Should never get here
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Client::WriteLineToClient(char *LineToSend)
{
	return WriteLineToClientEx(LineToSend, strlen(LineToSend));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

